/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.mccs;

import com.quantumdata.mccs.MCCSGUIFrame;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.SocketConnection;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class ConnectDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton jButtonClose;
    private JButton jButtonConnect;
    private JLabel jLabel1;
    private JLabel jLabelStatus;
    private JTextField jTextConnect;

    public ConnectDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        Toolkit toolkit = this.getToolkit();
        Dimension dimension = toolkit.getScreenSize();
        if (MCCSGUIFrame.m_instrument.isConnected()) {
            this.jTextConnect.setText(MCCSGUIFrame.m_instrument.getConnection().getName());
        } else {
            this.jTextConnect.setText(MCCSGUIFrame.m_instrument.getConnection().getName());
        }
        this.updateConnectButton();
        this.setBounds((dimension.width - this.getBounds().width) / 2, (dimension.height - this.getBounds().height) / 2, this.getBounds().width, this.getBounds().height);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                ConnectDialog.this.updateConnectButton();
            }
        });
    }

    private void updateConnectButton() {
        if (MCCSGUIFrame.m_instrument.isConnected()) {
            this.jButtonConnect.setText("Disconnect");
            this.jButtonConnect.setMnemonic('D');
            this.jLabelStatus.setText("Connected to " + MCCSGUIFrame.m_instrument.getConnection().getName());
        } else {
            this.jButtonConnect.setText("Connect");
            this.jButtonConnect.setMnemonic('C');
            this.jLabelStatus.setText("Disconnected");
        }
    }

    private void disableAll() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.jTextConnect.setEnabled(false);
        this.jButtonConnect.setEnabled(false);
        this.jButtonClose.setEnabled(false);
        this.repaint();
    }

    private void enableAll() {
        this.setCursor(Cursor.getDefaultCursor());
        this.jTextConnect.setEnabled(true);
        this.jButtonConnect.setEnabled(true);
        this.jButtonClose.setEnabled(true);
        this.repaint();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextConnect = new JTextField();
        this.jButtonConnect = new JButton();
        this.jLabelStatus = new JLabel();
        this.jButtonClose = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle("Connect to Generator...");
        this.setModal(true);
        this.setResizable(false);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setLabelFor(this.jTextConnect);
        this.jLabel1.setText("Connect To:");
        this.jLabel1.setMaximumSize(new Dimension(40, 14));
        this.jLabel1.setMinimumSize(new Dimension(100, 14));
        this.jLabel1.setPreferredSize(new Dimension(100, 14));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 33.3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jTextConnect.setMinimumSize(new Dimension(200, 19));
        this.jTextConnect.setPreferredSize(new Dimension(200, 19));
        this.jTextConnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectDialog.this.jTextConnectActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 90.0;
        gridBagConstraints.weighty = 33.3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.jTextConnect, gridBagConstraints);
        this.jButtonConnect.setMnemonic('C');
        this.jButtonConnect.setText("Connect");
        this.jButtonConnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectDialog.this.jButtonConnectActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 45.0;
        gridBagConstraints.weighty = 33.3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.jButtonConnect, gridBagConstraints);
        this.jLabelStatus.setHorizontalAlignment(0);
        this.jLabelStatus.setMaximumSize(new Dimension(40, 14));
        this.jLabelStatus.setMinimumSize(new Dimension(100, 14));
        this.jLabelStatus.setPreferredSize(new Dimension(100, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 33.3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.jLabelStatus, gridBagConstraints);
        this.jButtonClose.setMnemonic('C');
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectDialog.this.jButtonCloseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 45.0;
        gridBagConstraints.weighty = 33.3;
        this.getContentPane().add((Component)this.jButtonClose, gridBagConstraints);
        this.pack();
    }

    private void jTextConnectActionPerformed(ActionEvent actionEvent) {
        this.doConnect();
    }

    private void jButtonCloseActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private void jButtonConnectActionPerformed(ActionEvent actionEvent) {
        this.doConnect();
    }

    private void doConnect() {
        this.disableAll();
        if (MCCSGUIFrame.m_instrument.isConnected()) {
            try {
                MCCSGUIFrame.m_instrument.disconnect();
            }
            catch (Exception exception) {
                MCCSGUIFrame.m_instrument.setConnection(new SocketConnection(this.jTextConnect.getText()));
            }
        } else {
            this.jLabelStatus.setText("Attempting to connect to " + this.jTextConnect.getText() + "...");
            try {
                MCCSGUIFrame.m_instrument.setConnection(new SocketConnection(this.jTextConnect.getText()));
                MCCSGUIFrame.m_instrument.connect();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Unable to establish a connection with the address you specified.");
                this.enableAll();
                MCCSGUIFrame.updateConnectionInformation();
                this.updateConnectButton();
                return;
            }
            this.jLabelStatus.setText("Connected.  Gathering information...");
            String string = "EDID?";
            InstrumentResponse instrumentResponse = MCCSGUIFrame.m_instrument.sendCmd(string);
            if (!instrumentResponse.isError()) {
                // empty if block
            }
        }
        this.enableAll();
        MCCSGUIFrame.updateConnectionInformation();
        this.updateConnectButton();
        if (MCCSGUIFrame.m_instrument.isConnected()) {
            this.setVisible(false);
        }
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new ConnectDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }
}

